import Image from "next/image";

export default function StatusCard({data}){
    const {title, result, estimate, icon} = data;
    return(
        <div className="flex flex-col border bg-white border-[#e8e8e8] rounded px-4 lg:px-6 py-5 shadow-[0_0_8px_-4px_rgba(0,0,0,0.1)]">
            <div className="flex items-start">
                <div className="">
                    <h5 className="text-sm lg:text-base font-medium text-[#575757] pb-1 lg:pb-2">{title}</h5>
                    <h2 className="text-2xl lg:text-4xl font-bold text-[#404040]">{result}</h2>
                </div>
                <Image src={icon} width={'auto'} height={45} alt={title} className="ml-auto my-2 max-h-[30px] lg:max-h-[45px]"/>
            </div>
            {/* {
                estimate && 
                <p className="text-[15px] leading-5 text-[#424242] font-normal mt-7"><span className="text-primary font-semibold">+{estimate}%</span> per Month </p>
            } */}
        </div>
    )
}