"use client"
import { logo } from "@/assets/images";
import Image from "next/image";
import Link from "next/link";
import { usePathname } from "next/navigation";

export default function Navbar({isCollapsed}){
    const pathname = usePathname();
    

    return (
        <div className={`py-4`}>
            <div className={` ${isCollapsed ? 'w-full xl:w-16':'w-full'} relative overflow-hidden px-6 pb-4`}>
                <div className="w-52">
                    <Image className="w-52" src={logo} alt="Logo" width={200} height={50}/>
                </div>
            </div>

            <div className="px-4 max-h-[calc(100vh-60px)] overflow-y-auto scroll_bar">
                <ul className={`mx-auto flex flex-col py-2.5 space-y-3 ${isCollapsed ? 'px-2 xl:px-1':'px-2'} `}>
                    <li className="my-2.5">
                        <Link href="/admindashboard" className={`py-2.5 px-2.5 font-medium transition-all text-base flex rounded-md items-center my-0.5 group ${pathname === '/admindashboard' ? 'text-white bg-primary' : 'text-neutral-500 hover:text-white hover:bg-primary'}`}>
                            <span className="inline-block">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" className={`group-hover:fill-white ${pathname === '/admindashboard' ? 'fill-white' : 'fill-gray/70'} size-5`}>
                                    <path d="M4.28571 20.7332H9.03257V13.2795H14.9674V20.7332H19.7143V9.33215L12 3.58348L4.28571 9.33215V20.7332ZM3 22V8.69876L12 2L21 8.69876V22H13.6817V14.5462H10.3183V22H3Z"/>
                                </svg>
                            </span>
                            <span className={isCollapsed ? 'xl:hidden pl-0':'inline-block pl-3'}>Dashboard</span>
                        </Link>
                    </li>
                    <li className="my-2.5">
                        <Link href="/user-management" className={`py-2.5 px-2.5 font-medium transition-all text-base flex rounded-md items-center my-0.5 group ${pathname === '/user-management' ? 'text-white bg-primary' : 'text-neutral-500 hover:text-white hover:bg-primary'}`}>
                            <span className="inline-block">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" className={`group-hover:fill-white ${pathname === '/user-management' ? 'fill-white' : 'fill-gray/70'} size-5`}>
                                   <path d="M11.3115 7.90039C12.2253 7.90039 13.1152 8.18039 13.8486 8.7002L14.1152 8.90527C14.7132 9.40518 15.154 10.057 15.3828 10.7881L15.4668 11.1045C15.6084 11.7406 15.5866 12.4 15.4033 13.0264L15.2988 13.3359C15.0058 14.0947 14.4787 14.7475 13.793 15.2178C15.6861 15.9372 17.192 17.4459 17.7021 19.3311L17.7217 19.4512C17.7241 19.4915 17.7228 19.5321 17.7168 19.5723C17.7108 19.6127 17.7006 19.6522 17.6865 19.6904L17.6328 19.7998C17.6113 19.8344 17.5865 19.8668 17.5586 19.8965L17.4658 19.9775C17.3986 20.0257 17.3221 20.0612 17.2412 20.0811C17.2009 20.091 17.1595 20.0964 17.1182 20.0986L16.9932 20.0938C16.9519 20.0882 16.9113 20.0794 16.8721 20.0664L16.7588 20.0156C16.7227 19.9954 16.6885 19.9719 16.6572 19.9453L16.5713 19.8574C16.5458 19.8252 16.5243 19.7902 16.5059 19.7539L16.4619 19.6406C15.8901 17.5295 13.7276 15.9863 11.3115 15.9863C8.97099 15.9863 6.86877 17.4344 6.21973 19.4434L6.16113 19.6396C6.13977 19.7183 6.10276 19.7921 6.05176 19.8564C6.02625 19.8886 5.99715 19.9177 5.96582 19.9443L5.86426 20.0146C5.82806 20.0349 5.79034 20.0524 5.75098 20.0654L5.62988 20.0928C5.58842 20.0983 5.5465 20.1009 5.50488 20.0986L5.38184 20.0801C5.34141 20.0702 5.30221 20.0563 5.26465 20.0391L5.15723 19.9775C5.12345 19.9534 5.09259 19.9255 5.06445 19.8955L4.99023 19.7988C4.96869 19.7641 4.95052 19.7275 4.93652 19.6895L4.90625 19.5713C4.89432 19.4908 4.89954 19.4087 4.9209 19.3301L5.03223 18.9707C5.62745 17.254 7.0568 15.8902 8.8291 15.2178C8.23607 14.8109 7.76235 14.2677 7.45605 13.6367L7.32422 13.3359C7.0083 12.5176 6.97873 11.6237 7.24023 10.7881L7.35156 10.4795C7.63982 9.77263 8.13262 9.15516 8.77441 8.7002L9.05566 8.5166C9.72999 8.11445 10.5117 7.90039 11.3115 7.90039ZM26.459 17.501C26.6273 17.501 26.7896 17.5642 26.9102 17.6787L26.9912 17.7725C27.0612 17.8725 27.0995 17.9911 27.0996 18.1143C27.0996 18.2376 27.0614 18.3569 26.9912 18.457L26.9102 18.5508C26.7896 18.6653 26.6273 18.7285 26.459 18.7285H20.6885C20.5622 18.7285 20.4394 18.6931 20.335 18.627L20.2373 18.5508C20.1166 18.436 20.0479 18.2788 20.0479 18.1143C20.048 17.9498 20.1167 17.7934 20.2373 17.6787L20.335 17.6025C20.4394 17.5364 20.5622 17.501 20.6885 17.501H26.459ZM11.8906 9.18555C11.3145 9.07669 10.7172 9.13216 10.1748 9.3457C9.70016 9.53258 9.28655 9.83283 8.97266 10.2148L8.84473 10.3838C8.51959 10.8463 8.34578 11.3892 8.3457 11.9443C8.3457 12.6889 8.65726 13.4045 9.21289 13.9326L9.42969 14.1191C9.95738 14.5302 10.6217 14.7588 11.3115 14.7588C11.8991 14.7588 12.4731 14.5929 12.9609 14.2832L13.1387 14.1611C13.5413 13.8624 13.8559 13.469 14.0518 13.0195L14.1279 12.8252C14.2648 12.4311 14.3082 12.0133 14.2549 11.6016L14.2207 11.3965C14.1209 10.9199 13.8926 10.4765 13.5596 10.1094L13.4102 9.95703C13.0475 9.61233 12.5975 9.36318 12.1045 9.2334L11.8906 9.18555ZM26.459 13.3867C26.6273 13.3867 26.7896 13.4509 26.9102 13.5654C27.0308 13.6801 27.0995 13.8365 27.0996 14.001C27.0996 14.1656 27.0309 14.3228 26.9102 14.4375C26.7896 14.552 26.6273 14.6152 26.459 14.6152H18.5244C18.3561 14.6152 18.1937 14.552 18.0732 14.4375C17.9525 14.3228 17.8838 14.1656 17.8838 14.001C17.8839 13.8366 17.9526 13.6801 18.0732 13.5654C18.1937 13.4509 18.3561 13.3868 18.5244 13.3867H26.459ZM26.459 9.27344C26.6274 9.27344 26.7896 9.33762 26.9102 9.45215C27.0308 9.56681 27.0995 9.72325 27.0996 9.8877C27.0996 10.0523 27.0309 10.2095 26.9102 10.3242C26.7896 10.4387 26.6273 10.502 26.459 10.502H18.5244C18.3561 10.5019 18.1937 10.4387 18.0732 10.3242C17.9525 10.2095 17.8838 10.0523 17.8838 9.8877C17.8839 9.72327 17.9526 9.5668 18.0732 9.45215C18.1937 9.33762 18.3561 9.27349 18.5244 9.27344H26.459Z" />
                                </svg>
                            </span>
                            <span className={isCollapsed ? 'xl:hidden pl-0':'inline-block pl-3'}>User Management</span>
                        </Link>
                    </li>

                    <li className="my-2.5">
                        <Link href="/content-management" className={`py-2.5 px-2.5 font-medium transition-all text-base flex rounded-md items-center my-0.5 group ${pathname === '/content-management' ? 'text-white bg-primary' : 'text-neutral-500 hover:text-white hover:bg-primary'}`}>
                            <span className="inline-block">
                                <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg" className={`group-hover:stroke-white ${pathname === '/content-management' ? 'stroke-white' : 'stroke-gray/70'} size-5`}>
                                    <path d="M20 5.9502C20.8089 5.9502 21.5843 6.27176 22.1562 6.84375C22.7282 7.41574 23.0498 8.19109 23.0498 9V20C23.0498 20.8089 22.7282 21.5843 22.1562 22.1562C21.5843 22.7282 20.8089 23.0498 20 23.0498H12C11.1911 23.0498 10.4157 22.7282 9.84375 22.1562C9.27176 21.5843 8.9502 20.8089 8.9502 20V18.9502H10.0498V20C10.0498 20.5172 10.2554 21.0132 10.6211 21.3789C10.9868 21.7446 11.4828 21.9502 12 21.9502H20C20.5172 21.9502 21.0132 21.7446 21.3789 21.3789C21.7446 21.0132 21.9502 20.5172 21.9502 20V9C21.9502 8.48283 21.7446 7.98679 21.3789 7.62109C21.0132 7.2554 20.5172 7.0498 20 7.0498H12C11.4828 7.0498 10.9868 7.2554 10.6211 7.62109C10.2554 7.98679 10.0498 8.48283 10.0498 9V14.0498H8.9502V9C8.9502 8.19109 9.27176 7.41574 9.84375 6.84375C10.4157 6.27176 11.1911 5.9502 12 5.9502H20ZM18.0498 1.9502V3.0498H8C7.48283 3.0498 6.98679 3.2554 6.62109 3.62109C6.2554 3.98679 6.0498 4.48283 6.0498 5V14C6.0498 14.5172 6.2554 15.0132 6.62109 15.3789C6.98679 15.7446 7.48283 15.9502 8 15.9502H15.1299L12.9316 13.752L12.9629 13.7168L13.6221 12.9668L13.6572 12.9268L17.2305 16.5L13.6572 20.0732L13.6221 20.0332L12.9629 19.2832L12.9316 19.248L15.1299 17.0498H8C7.29231 17.0498 6.61008 16.8039 6.06738 16.3594L5.84375 16.1562C5.27176 15.5843 4.9502 14.8089 4.9502 14V5C4.9502 4.19109 5.27176 3.41574 5.84375 2.84375L6.06738 2.64062C6.61008 2.19606 7.29231 1.9502 8 1.9502H18.0498Z"/>
                                </svg>
                            </span>
                            <span className={isCollapsed ? 'xl:hidden pl-0':'inline-block pl-3'}>Content Management</span>
                        </Link>
                    </li>

                    <li className="my-2.5">
                        <Link href="/report-analystics" className={`py-2.5 px-2.5 font-medium transition-all text-base flex rounded-md items-center my-0.5 group ${pathname === '/report-analystics' ? 'text-white bg-primary' : 'text-neutral-500 hover:text-white hover:bg-primary'}`}>
                            <span className="inline-block">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" className={`group-hover:fill-white ${pathname === '/report-analystics' ? 'fill-white' : 'fill-gray/70'} size-5`}>
                                    <path d="M9 2C8.4 2 8 2.4 8 3V21C8 21.6 8.4 22 9 22C9.6 22 10 21.6 10 21V3C10 2.4 9.6 2 9 2ZM4 12C3.4 12 3 12.4 3 13V21C3 21.6 3.4 22 4 22C4.6 22 5 21.6 5 21V13C5 12.4 4.6 12 4 12ZM14 8C13.4 8 13 8.4 13 9V21C13 21.6 13.4 22 14 22C14.6 22 15 21.6 15 21V9C15 8.4 14.6 8 14 8ZM19 16C18.4 16 18 16.4 18 17V21C18 21.6 18.4 22 19 22C19.6 22 20 21.6 20 21V17C20 16.4 19.6 16 19 16Z"/>
                                </svg>
                            </span>
                            <span className={isCollapsed ? 'xl:hidden pl-0':'inline-block pl-3'}>Report & Analytics</span>
                        </Link>
                    </li>

                    <li className="my-2.5">
                        <Link href="/subscription-billings" className={`py-2.5 px-2.5 font-medium transition-all text-base flex rounded-md items-center my-0.5 group ${pathname === '/subscription-billings' ? 'text-white bg-primary' : 'text-neutral-500 hover:text-white hover:bg-primary'}`}>
                            <span className="inline-block">
                               <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" className={`group-hover:fill-white ${pathname === '/subscription-billings' ? 'fill-white' : 'fill-gray/70'} size-5`}>
                                    <path d="M4.28571 8.14286V19.7143H15.8571V8.14286H4.28571ZM3.64286 6.85714H16.5C16.6705 6.85714 16.834 6.92487 16.9546 7.04543C17.0751 7.16599 17.1429 7.3295 17.1429 7.5V20.3571C17.1429 20.5276 17.0751 20.6912 16.9546 20.8117C16.834 20.9323 16.6705 21 16.5 21H3.64286C3.47236 21 3.30885 20.9323 3.18829 20.8117C3.06773 20.6912 3 20.5276 3 20.3571V7.5C3 7.3295 3.06773 7.16599 3.18829 7.04543C3.30885 6.92487 3.47236 6.85714 3.64286 6.85714ZM21 3.64286V17.7857C21 17.9562 20.9323 18.1197 20.8117 18.2403C20.6912 18.3608 20.5276 18.4286 20.3571 18.4286H18.4286V17.1429H19.7143V4.28571H9.42857V5.57143H8.14286V3.64286C8.14286 3.47236 8.21059 3.30885 8.33115 3.18829C8.4517 3.06773 8.61522 3 8.78571 3H20.3571C20.5276 3 20.6912 3.06773 20.8117 3.18829C20.9323 3.30885 21 3.47236 21 3.64286ZM6.85714 15.2143H13.2857V16.5H6.85714V15.2143ZM6.85714 11.3571H13.2857V12.6429H6.85714V11.3571Z"/>
                                </svg>
                            </span>
                            <span className={isCollapsed ? 'xl:hidden pl-0':'inline-block pl-3'}>Subscription & Billing</span>
                        </Link>
                    </li>
                    
                     <li className="my-2.5">
                       <Link href="/coupon-management" className={`py-2.5 px-2.5 font-medium transition-all text-base flex rounded-md items-center my-0.5 group ${pathname === '/coupon-management' ? 'text-white bg-primary' : 'text-neutral-500 hover:text-white hover:bg-primary'}`}>
                            <span className="inline-block">
                               
                             <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"  className={`group-hover:fill-white ${pathname === '/coupon-management' ? 'fill-white' : 'fill-gray/70'} size-5`}>
                                <path d="M9.23077 5V8.5M9.23077 9.9V14.8M9.23077 16.2V19M3 18.3H21V14.8C20.3077 14.5662 18.9231 13.68 18.9231 12C18.9231 9.9 21 9.9 21 9.2V5.7H3V9.2C3.69231 9.4338 5.07692 10.32 5.07692 12C5.07692 14.1 3 14.1 3 14.8V18.3Z"/>
                            </svg>


                            </span>
                            <span className={isCollapsed ? 'xl:hidden pl-0':'inline-block pl-3'}>Coupon Management</span>
                        </Link>
                    </li>                    
                </ul>
            </div>
        </div>
    )
}