"use client"
import { useState } from "react";
import Navbar from "./NavbarAdmin";
import Header from "./Header";

export default function Layout({children}){
    const [hasFloat, setHasFloat] = useState(true);
    const [isCollapsed, setIsCollapsed] = useState(false);   

    return (
        <div className={`xl:flex items-stretch w-full min-h-screen relative`}>
            <aside className={`bg-white xl:bg-white/80 border-r h-screen fixed top-0 xl:sticky z-[11] xl:top-0 border-gray/[.17] text-white transition-all shadow-[0_0_64px_rgba(0,0,0,0.1)] ${isCollapsed ? 'left-0 w-72 xl:w-20 shrink-0':'-left-72 xl:left-0 w-72'}  duration-300 ${hasFloat ? 'block' : 'hidden xl:block'}`}>
                <button onClick={() => setIsCollapsed(!isCollapsed)} type="button" className="w-6 cursor-pointer h-6 inline-flex items-center justify-center z-10 border rounded-full text-neutral-500 shadow-neutral-200 border-gray/20 absolute top-7 -right-8 left-auto bg-white shadow-lg">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" className={` ${isCollapsed ? 'rotate-180':'rotate-0'} size-4 transition-all`}>
                        <path fillRule="evenodd" d="M4.72 9.47a.75.75 0 0 0 0 1.06l4.25 4.25a.75.75 0 1 0 1.06-1.06L6.31 10l3.72-3.72a.75.75 0 1 0-1.06-1.06L4.72 9.47Zm9.25-4.25L9.72 9.47a.75.75 0 0 0 0 1.06l4.25 4.25a.75.75 0 1 0 1.06-1.06L11.31 10l3.72-3.72a.75.75 0 0 0-1.06-1.06Z" clipRule="evenodd" />
                    </svg>
                </button>
                <Navbar isCollapsed={isCollapsed}/>
            </aside>

            {/* Main Content */}
            <div className="flex flex-col flex-1">

                {/* Header */}
                <div className="sticky top-0 z-10">
                    <Header/>
                </div>

                {/* Body */}
                <main className="flex-1 px-5">
                    {children}
                </main>
            </div>
        </div>
    )
}