"use client";
import Layout from "@/components/Layout/LayoutAdmin";
import Image from "next/image";
import {search, EyeIcon,  trashIcon, edit} from '@/assets/images';
import axios from "axios";
import { useAuth } from "@/context/AuthContext";
import { useEffect, useState } from "react";
import { formatDateWithOrdinal } from "@/utils/dateFormat";


export default function UserManagement() {
  // const [userList, setUserList] = useState(null);
  const { user, loading } = useAuth();
  const authID = user ? user.userId : 0;
  const [results, setResults] = useState([]);

  const apiUrl = process.env.NEXT_PUBLIC_API_URL;

  const fetchUsers = async () => {
    try {
      const response = await axios.get(`${apiUrl}/users/list`, {
          headers: {
            Authorization: `Bearer ${user?.token}`
          }
        });
      console.log("Fetched users:", response.data);
      setResults(response.data || null);
      console.log("User List:", results);
      
    } catch (err) {
      setResults(null);
    }
  };
  useEffect(() => {
    if (user?.token) {  
      fetchUsers();
    }
  }, [user]);

  // const results = [
  //   {
  //     id: 1,
  //     slno:1,
  //     userid: 'U001',
  //     name: 'John Steinbeck',
  //     email:'john.steinbeck@mailverse.com',
  //     plan:'Monthly',
  //     status:'Active',
  //     role:'Author',
  //     uploadedbooks:'10',
  //     lastlogin:'April 28, 2025 - 10:15 AM',
  //     registerdate:'April 28, 2025 ',
   
  //   },
  //   {
  //     id: 2,
  //     slno:2,
  //      userid: 'U002',
  //     name: 'Ernest Hemingway',
  //     email:'ernest.hemingway@writerhub.org',
  //     plan:'Yearly',
  //     status:'Inactive',
  //     role:'Publisher',
  //     uploadedbooks:'15',
  //     lastlogin:'April 28, 2025 - 10:46 AM',
  //     registerdate:'April 28, 2025 ',
  //   },
  //   {
  //     id: 3,
  //     slno:3,
  //   userid: 'U003',
  //     name: 'JD.Salinger.',
  //     email:'jd.salinger@inkwell.io',
  //     plan:'One-Time Search',
  //     status:'Suspended',
  //     role:'Author Association',
  //     uploadedbooks:'20',
  //     lastlogin:'April 28, 2025 - 11:00 AM ',
  //     registerdate:'April 28, 2025 ',
  //   },
  //   {
  //     id: 4,
  //     slno:4,
  //     userid: 'U004',
  //     name: 'Harper Lee',
  //     email:'harper.lee@penandpage.net',
  //     plan:'Monthly',
  //     status:'Banned',
  //     role:'Publisher',
  //     uploadedbooks:'22',
  //     lastlogin:'April 28, 2025 - 11:15 AM',
  //     registerdate:'April 28, 2025 ',
  //   },
  //   {
  //    id: 5,
  //    slno:5,
  //    userid: 'U005',
  //     name: 'John Green',
  //     email:'john.green@literarylane.co',
  //     plan:'Yearly',
  //     status:'Pending verification',
  //     role:'Author',
  //     uploadedbooks:'11',
  //     lastlogin:'April 28, 2025 - 11:30 AM',
  //     registerdate:'April 28, 2025 ',
  //   },
    
  // ]
  return (
    <Layout>
        <div className="max-w-full mx-auto my-10">
            

                 <div className="flex items-center w-full max-w-full space-x-2">
                    <div className="flex items-center flex-grow border border-gray-300 rounded-md px-3">
                    <Image src={search} width={'auto'}  alt="search"/>
                        <input
                        type="text"
                        placeholder="Search By Name/Email/Plan"
                        className="w-full pl-2 text-sm placeholder-gray-400 focus:outline-none leading-[56px]"
                        />
                    </div>
                    <button className="bg-emerald-500 text-white text-sm font-medium px-5 leading-[56px] rounded-md hover:bg-emerald-600 transition">
                        Search
                    </button>
                 </div>
              <h3 className="mb-5 font-semibold text-[#373737] text-2xl mt-10">User List</h3>
            <div className="table_wpr pb-5 mt-5">
                <div className="w-full overflow-x-auto">
                    <table className="glob_table">
                    <thead>
                        <tr>
                        <th>Sl. No</th>
                        {/* <th>User ID</th> */}
                        <th>Name</th>
                        <th>Email Address</th>
                        <th>Subscription Plan</th>
                        <th>Account Status</th>
                        <th>Role</th>
                        <th>Uploaded Books</th>
                        <th>Last Login</th>
                        <th>Date Registered</th>
                        <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        {results
    ? results.map((result, r) => (
        <tr key={r}>
          <td className="max-w-32">{result.id}</td>
          {/* <td className="max-w-32">{result.userID}</td> */}
          <td>{result.name}</td>
          <td>{result.email}</td>
          <td>{result.plan}</td>
          <td>
            <span className="inline-flex items-center space-x-1">
              <span
                className={`w-2 h-2 rounded-full ${
                  result.status === 'Active'
                    ? 'bg-green-600'
                    : result.status === 'Inactive'
                    ? 'bg-orange-400'
                    : result.status === 'Suspended'
                    ? 'bg-pink-500'
                    : result.status === 'Banned'
                    ? 'bg-red-500'
                    : result.status === 'Pending verification'
                    ? 'bg-indigo-400'
                    : 'bg-gray-400'
                }`}
              ></span>
              <span
                className={`text-sm ${
                  result.status === 'Active'
                    ? 'text-green-600'
                    : result.status === 'Inactive'
                    ? 'text-orange-500'
                    : result.status === 'Suspended'
                    ? 'text-pink-500'
                    : result.status === 'Banned'
                    ? 'text-red-500'
                    : result.status === 'Pending verification'
                    ? 'text-indigo-500'
                    : 'text-gray-500'
                }`}
              >
                {result.status}
              </span>
            </span>
          </td>
          <td>
  {result.userType === "Au"
    ? "Author"
    : result.userType === "Pu"
    ? "Publisher"
    : result.userType === "Ad"
    ? "Admin"
    : result.userType}
</td>
          <td className="text-center">{result.uploadedbooks || 0}</td>
          <td>
            {result.activityLog && result.activityLog.length > 0
              ? formatDateWithOrdinal(result.activityLog[0].timestamp)
              : ""}
          </td>
          <td>
            {result.createdAt ? formatDateWithOrdinal(result.createdAt) : ""}
          </td>
          <td>
            <ul className="flex items-center justify-center space-x-1">
              <li className="cursor-pointer">
                <Image src={EyeIcon} width="auto" alt="view" />
              </li>
              <li className="cursor-pointer">
                <Image src={trashIcon} width="auto" alt="Trash" />
              </li>
              <li className="cursor-pointer">
                <Image src={edit} width="auto" alt="Edit" />
              </li>
            </ul>
          </td>
        </tr>
      ))
    : ""}
                    </tbody>
                    </table>
                </div>
            </div>




                
        </div>
    </Layout>
  );
}