"use client";
import BookUplad from "@/components/BookUpload";
import Layout from "@/components/Layout/Layout";
import { useAuth } from "@/context/AuthContext";

export default function UploadBooks() {
  const { user, loading } = useAuth();
  if (loading) return null; // or a loading spinner
  if (!user) {
    return (
      <Layout>
        <div className="max-w-3xl mx-auto my-10">
          <h1 className="text-center text-2xl font-bold">Please log in to upload books</h1>
        </div>
      </Layout>
    );
  }
  return (
    <Layout>
      <div className="max-w-3xl mx-auto my-10">
        <BookUplad/>
      </div>
    </Layout>
  );
}