'use client';

import Layout from "@/components/Layout/Layout";
import { loadStripe } from "@stripe/stripe-js";
import { useEffect, useState } from "react";
import { useSearchParams } from 'next/navigation';
import axios from "axios";
import { useAuth } from "@/context/AuthContext";

const stripePromise = loadStripe(process.env.NEXT_PUBLIC_STRIPE_PUBLISHABLE_KEY);

export default function Reviews({ params }) {
  const { id } = params;
  const [loading, setLoading] = useState(false);
  const [result, setResult] = useState(null);
  const searchParams = useSearchParams();
  const sessionId = searchParams.get('session_id');
  const oid = searchParams.get('oid');
  const { user } = useAuth();

  useEffect(() => {
    if (sessionId) {
      setLoading(true);
      axios
        .get(`${process.env.NEXT_PUBLIC_API_URL}/checkout/stripe-session/${sessionId}/${oid}`, {
          headers: {
            Authorization: `Bearer ${user?.token}`
          }
        })
        .then(res => {
          setResult(res.data);
          setLoading(false);
        })
        .catch(() => setLoading(false));
    }
  }, [sessionId, user]);

  

  return (
    <Layout>
      <div className="max-w-full mx-auto my-10">
        <h3 className="mb-5 font-semibold text-[#373737] text-2xl">Success</h3>
        <div className='border border-[#E8E8E8]'>
          <div className='bg-[#ECEFF6] h-[44px] w-full'></div>
          <div className='text-center p-14'>
            {loading && <p>Loading session details...</p>}
            {!loading && result && (
              <>
                <p className="mb-2 text-gray-700">Thank you for your purchase.</p>
                <div className="mt-4 text-left">
                  <div><span className="font-semibold">Plan:</span> {result.order?.planName}</div>
                  <div><span className="font-semibold">Payment Email:</span> {result.session.customer_details?.email}</div>
                  <div><span className="font-semibold">Amount:</span> ${(result.session.amount_total / 100).toFixed(2)}</div>
                  <div><span className="font-semibold">Payment Status:</span> {result.session.payment_status}</div>
                  <div><span className="font-semibold">Payment Intent:</span> {result.session.payment_intent}</div>
                  {/* <div><span className="font-semibold">Session ID:</span> <span className="break-all text-gray-500 text-sm">{result.session.id}</span></div> */}
                </div>
              </>
            )}
            {!loading && !result && (
              <p className="text-red-500">Could not load session details.</p>
            )}
            <a
              href="/"
              className="inline-block mt-8 px-6 py-2 bg-primary text-white rounded hover:bg-primaryDark transition"
            >
              Go to Dashboard
            </a>
          </div>
        </div>
      </div>
    </Layout>
  );
}