'use client'
import { useState } from 'react';
import Layout from "@/components/Layout/LayoutAdmin";
import StatusCard from "@/components/StatusCard";
import Image from "next/image";
import {search, EyeIcon, pause, edit, activesubscription,monthlyrevenue,rate,totalsubcriptions } from '@/assets/images';
import { useAuth } from "@/context/AuthContext";
import axios from "axios";
import { useEffect } from "react";
import { formatOnlyDate } from "@/utils/dateFormat";
import { useRouter } from 'next/navigation';
// import ReactQuill from 'react-quill';
// import 'react-quill/dist/quill.snow.css';
// user-management/page.js
import dynamic from "next/dynamic";


const MDEditor = dynamic(() => import("@uiw/react-md-editor"), { ssr: false });



// ...rest of your code...


export default function CoumponManagement() {
 const [showModal, setShowModal] = useState(false);
 const { user, loading } = useAuth();
 const authID = user ? user.userId : 0;
 const [results, setResults] = useState([]);
 const [modalData, setModalData] = useState();
 const [isModalOpen, setIsModalOpen] = useState(false);
 const [desc, setDesc] = useState('');
 const [planName, setPlanName] = useState('');
 const [planPrice, setPlanPrice] = useState('');
 const [planStatus, setPlanStatus] = useState('');
  const [planValidity, setPlanValidity] = useState('');
  const [planSearch, setPlanSearch] = useState('');

  const quickCards = [
    {
      title: 'Active Subscription ',
      result: '1,852',
      icon: activesubscription
    },
    {
      title: 'Monthly Revenue',
      result: '$24,863',
      icon: monthlyrevenue
    },
    {
      title: 'New Subscriptions',
      result: '184',
      icon: totalsubcriptions
    },

    {
      title: 'Churn Rate',
      result: '3.2%',
      icon: rate
    },
    
  ]

  //   const results = [
  //   {
  //     id: 1,
  //     sl:'1',
  //     User: 'John Smith',
  //     plan:'Annual Author',
  //     startdate: 'Jan 15, 2025',
  //     enddate: 'Jan 15, 2026',
  //     amount:'$149.99',
  //     status:'Active'
      
  //   },
  //   {
  //     id: 2,
  //     sl:'2',
  //     User: 'Penguin Publishing',
  //     plan:'Enterprise (25 books)',
  //     startdate: 'Feb 03, 2025',
  //     enddate: 'Feb 03, 2026',
  //     amount:'$2500.00',
  //     status:'Active'
    
  //   },
  //   {
  //     id: 3,
  //     sl:'3',
  //     User: 'Brooklyn Simmons',
  //     plan:'Enterprise (50 books)',
  //     startdate: 'Mar 06, 2025',
  //     enddate: 'Mar 06, 2026',
  //     amount:'$149.00',
  //     status:'Active'
  //   },
   
  // ]

 

  const apiUrl = process.env.NEXT_PUBLIC_API_URL;

  const fetchPlans = async () => {
    try {
      const response = await axios.get(`${apiUrl}/getdata/plans`, {
          headers: {
            Authorization: `Bearer ${user?.token}`
          }
        });
      console.log("plans:", response.data);
      setResults(response.data || null);
      console.log("plan list:", results);
      
    } catch (err) {
      setResults(null);
    }
  };
  useEffect(() => {
    if (user?.token) {  
      fetchPlans();
    }
  }, [user]);

  const openModal = (res_array) => {
    console.log("Edit num:", res_array);
    setModalData(res_array);
    setDesc(res_array.desc || '');
    setPlanName(res_array.name || '');
    setPlanPrice(res_array.price || '');
    setPlanStatus(res_array.status || '');
    setPlanValidity(res_array.validity || '');
    setPlanSearch(res_array.searchCount || '');
    setShowModal(true);
    setIsModalOpen(true);
  }

  const savePlan = async () => {
    const updatedData = {
      planId: modalData._id,
      name: planName,
      desc: desc,
      status: planStatus,
      price: planPrice,
      validity: planValidity,
      searchCount: planSearch,
    };

    try {
      const response = await axios.post(`${apiUrl}/getdata/plan-update/`, updatedData, {
        headers: {
          Authorization: `Bearer ${user?.token}`
        }
      });
      console.log("Updated plan:", response.data);
      setShowModal(false);
      alert("Plan updated successfully!");
      fetchPlans();
    } catch (error) {
      console.error("Error updating plan:", error);
    }
  }

  return (
    <Layout>
        <div className="max-w-full mx-auto my-10">
            
            <ul className="flex flex-wrap -mx-2.5 mt-5 mb-10">
                {quickCards.map((card, c) => (
                    <li
                    key={c}
                    className="w-full xs:w-1/2 md:w-1/3 p-2.5"
                    >
                    <StatusCard data={card} />
                    </li>
                ))}
            </ul>
          
           <h3 className="mb-5 font-semibold text-[#373737] text-2xl">All subscription</h3>
            {/* <div className="flex items-center w-full max-w-full space-x-2 mb-5">
                                 <div className="flex items-center flex-grow border border-gray-300 rounded-md px-3">
                                 <Image src={search} width={'auto'}  alt="search"/>
                                     <input
                                     type="text"
                                     placeholder="Search by User or Plan or Status"
                                     className="w-full pl-2 text-sm placeholder-gray-400 focus:outline-none leading-[56px]"
                                     />
                                 </div>
                                 <button className="bg-emerald-500 text-white text-sm font-medium px-5 leading-[56px] rounded-md hover:bg-emerald-600 transition">
                                     Search
                                 </button>
            </div> */}

          
            <div className="table_wpr pb-5">
                <div className="relative overflow-x-auto">
                    <table className="glob_table">
                        <thead>
                            <tr>
                            <th>Sl. No.</th>
                            <th>Plan</th>
                            <th>Created Date</th>
                            <th>Amount</th>
                            <th>Status</th>
                            <th className='text-center'>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            {
                            results.map((result, r) => (
                                <tr key={r}>
                                <td className="max-w-32">{r+1}</td>
                                <td>{result.name}</td>
                                <td>{formatOnlyDate(result.created_at)}</td>
                                <td>{result.price}</td>
                                <td>
                                    <span className="inline-flex items-center space-x-1">
                                    <span
                                    className={`w-2 h-2 rounded-full ${
                                        result.status === true
                                        ? 'bg-green-600'
                                        : result.status === false
                                        ? 'bg-red-400'
                                        : 'bg-gray-400'
                                    }`}
                                    ></span>
                                    <span
                                    className={`text-sm ${
                                        result.status === true
                                        ? 'text-green-600'
                                        : result.status === false
                                        ? 'text-orange-500'
                                        : 'text-gray-500'
                                    }`}
                                    >
                                    {
                                        result.status === true
                                        ? 'Active'
                                        : result.status === false
                                        ? 'Inactive'
                                        : 'None'
                                    }
                                    </span>
                                </span>
                                </td>
                                <td>
                                    <ul className="flex items-center justify-center space-x-1">
                                                                    <li className="cursor-pointer" onClick={() => openModal(result)}><Image src={edit} width={18} height={18} alt="Edit" /></li>
                                                                  {/* <li className="cursor-pointer">
                                                                    <Image src={pause} width="auto" alt="Trash" /> 
                                                                    </li>*/}
                                                                  
                                                                </ul>
                                </td>
                                
                                </tr>
                            ))
                            }
                        </tbody>
                    </table>
                    {showModal && (
        <div className="fixed inset-0 bg-[#00000041] bg-opacity-50 flex items-center justify-center z-50">
          <div className="bg-white rounded-lg p-6 w-full max-w-5xl relative">
            <button
              className="absolute top-3 right-4 text-2xl cursor-pointer text-gray-500 hover:text-black"
              onClick={() => setShowModal(false)}
            >
              &times;
            </button>

            <h2 className="text-lg font-bold mb-4">Edit Actions</h2>

            <div className="mb-4">
              <label className="block text-sm font-medium mb-1 text-[#373737]">Plan Name</label>
              <input
                type="text"
                defaultValue={planName}
                onChange={setPlanName}
                className="w-full border rounded-md border-[#C4C4C4] px-3 py-2 outline-none"
              />
            </div>

            {/* <div className="grid grid-cols-2 gap-4 mb-4">
              <div>
                <label className="block text-sm font-medium mb-1 text-[#373737]">Start Date</label>
                <input
                  type="date"
                  defaultValue="2025-01-15"
                  className="w-full border border-[#C4C4C4] rounded-md px-3 py-2 outline-none"
                />
              </div>
              <div>
                <label className="block text-sm font-medium mb-1 text-[#373737]">End Date</label>
                <input
                  type="date"
                  defaultValue="2025-01-15"
                  className="w-full border-[#C4C4C4] border rounded-md px-3 py-2 outline-none"
                />
              </div>
            </div> */}

            <div className="mb-4">
              <label className="block text-sm font-medium mb-1">Status</label>
              <div className="flex items-center gap-6 mt-1">
                <label className="flex items-center gap-2">
                  <input
                    type="radio"
                    name="status"
                    checked={planStatus === true}
                    onChange={() => setPlanStatus(true)}
                    value="true"
                  /> Active
                </label>
                <label className="flex items-center gap-2">
                  <input
                    type="radio"
                    name="status"
                    checked={planStatus === false}
                    onChange={() => setPlanStatus(false)}
                    value="false"
                  /> Inactive
                </label>
                {/* <label className="flex items-center gap-2">
                  <input type="radio" name="status" /> Paused
                </label> */}
              </div>
            </div>

            <div className="mb-4">
              <label className="block text-sm font-medium mb-2 text-[#373737]">Plan Description</label>
              {/* <textarea
                rows={3}
                defaultValue={modalData?.desc || ''}
                className="w-full border border-[#C4C4C4] rounded-md px-3 py-2 outline-none resize-none"
              ></textarea> */}
              <div data-color-mode="light">
                <MDEditor value={desc} onChange={setDesc} />
              </div>
            </div>

            <div className="mb-6">
              <label className="block text-sm font-medium mb-1 text-[#373737]">Amount</label>
              <input
                type="text"
                defaultValue={planPrice}
                onChange={(e) => setPlanPrice(e.target.value)}
                className="w-full border rounded-md px-3 py-2 outline-none border-[#C4C4C4]"
              />
            </div>
            
            <div className="mb-6">
              <label className="block text-sm font-medium mb-1 text-[#373737]">Validity(Days)</label>
              <input
                type="text"
                defaultValue={planValidity}
                onChange={(e) => setPlanValidity(e.target.value)}
                className="w-full border rounded-md px-3 py-2 outline-none border-[#C4C4C4]"
              />
            </div>
            <div className="mb-6">
              <label className="block text-sm font-medium mb-1 text-[#373737]">Number of Search</label>
              <input
                type="text"
                defaultValue={planSearch}
                onChange={(e) => setPlanSearch(e.target.value)}
                className="w-full border rounded-md px-3 py-2 outline-none border-[#C4C4C4]"
              />
            </div>

            <div className="flex justify-end gap-3">
              <button
                className="border border-gray-300 px-10 cursor-pointer py-2 rounded-md hover:bg-gray-100"
                onClick={() => setShowModal(false)}
              >
                Reset
              </button>
              <button className="bg-[#04b47d] cursor-pointer text-white px-10 py-2 rounded-md hover:bg-green-700" onClick={savePlan}>
                Save
              </button>
            </div>
          </div>
        </div>
      )}
                </div>
            </div>

                 {/* <div className="flex justify-end mt-8"><ul className="flex items-center space-x-2"><li className="w-8 h-8 border border-[#c9c9c9] flex items-center justify-center bg-white text-black text-sm font-medium rounded cursor-pointer">1</li><li className="w-8 h-8 border border-[#c9c9c9] flex items-center justify-center bg-primary text-white text-sm font-medium rounded cursor-pointer">2</li><li className="w-8 h-8 border border-[#c9c9c9] flex items-center justify-center bg-white text-black text-sm font-medium rounded cursor-pointer">3</li><li className="w-8 h-8 border border-[#c9c9c9] flex items-center justify-center bg-white text-black text-sm font-medium rounded cursor-pointer">4</li><li className="px-5 h-8 border border-[#c9c9c9] flex items-center justify-center bg-white text-black text-sm font-medium rounded cursor-pointer">Next</li></ul></div> */}
        




                
        </div>
    </Layout>
  );
}