"use client"
import Layout from "@/components/Layout/Layout";
import StatusCard from "@/components/StatusCard";
import Link from "next/link";
import Image from "next/image";
import { matchingIcon, pendingIcon, bookIcon, EyeIcon, trashIcon, fileIcon } from '@/assets/images'
import axios from "axios";
import React, { useEffect, useState, useRef } from "react";
import { useAuth } from "@/context/AuthContext";
import { useRouter } from "next/navigation";
import Modal from "@/components/Modal";

export default function Dashboard() {
  const [results, setResults] = useState([]);
  const [currentPage, setCurrentPage] = useState(1);
  const resultsPerPage = 5;
  const [isOpen, setIsOpen] = useState(false);
  const modalRef = useRef(null);

  // Book details state
  const [itemID, setItemID] = useState("");
  const [bookName, setBookName] = useState("");
  const [authorName, setAuthorName] = useState("");
  const [publisherName, setPublisherName] = useState("");
  const [keyword, setKeyword] = useState("");
  const [saving, setSaving] = useState(false);
  const [matchCount, setMatchCount] = useState(0);
  const [pendingrescan, setPendingrescan] = useState(0);
  const [saveMessage, setSaveMessage] = useState("");

  const { user, loading } = useAuth();
  const router = useRouter();
  const authID = user ? user.userId : 0; // Default to 0 if user is not authenticated

  useEffect(() => {
    if (!loading && !user) {
      router.push("/login");
    }
  }, [user, loading, router]);

  useEffect(() => {
    if (user) {
      fetchData();
      searchmatchcount();
      pendingrescan_function();
    }
    // eslint-disable-next-line
  }, [user]);

  const fetchData = async () => {
    const apiUrl = process.env.NEXT_PUBLIC_API_URL;
    const response = await axios.get(`${apiUrl}/getdata?tab=uploads&authID=${authID}&keyName=&keyValue=`, {
          headers: {
            Authorization: `Bearer ${user?.token}`
          }
        });
    setResults(response.data);
  };

  const searchmatchcount = async () => {
    const apiUrl = process.env.NEXT_PUBLIC_API_URL;
    const response = await axios.get(`${apiUrl}/getdata/searchmatchcount?authID=${authID}`, {
          headers: {
            Authorization: `Bearer ${user?.token}`
          }
        });
    setMatchCount(response.data.count); // Use .count from backend response
  };

  const pendingrescan_function = async () => {
    const apiUrl = process.env.NEXT_PUBLIC_API_URL;
    const response = await axios.get(`${apiUrl}/getdata/pendingrescan?authID=${authID}`, {
          headers: {
            Authorization: `Bearer ${user?.token}`
          }
        });
    setPendingrescan(response.data.count); // Use .count from backend response
  };

  const setBookDetails = (book) => {
    setIsOpen(true);
    if (book) {
      setItemID(book.itemid || "");
      setBookName(book.name || "");
      setAuthorName(book.author || "");
      setPublisherName(book.publisher || "");
      setKeyword(book.keywords || "");
      setSaveMessage("");
    }
  };

  // const handleSaveBook = async () => {
  //   setSaving(true);
  //   setSaveMessage("");
  //   try {
  //     const apiUrl = process.env.NEXT_PUBLIC_API_URL;
  //     // Adjust endpoint and payload as per your backend API
  //     await axios.post(`${apiUrl}/updatebook`, {
  //       itemid: itemID,
  //       title: bookName,
  //       author: authorName,
  //       publisher: publisherName,
  //       keywords: keyword,
  //     });
  //     setSaveMessage("Book details saved!");
  //     fetchData(); // Refresh list
  //     setTimeout(() => {
  //       setIsOpen(false);
  //       setSaveMessage("");
  //     }, 1000);
  //   } catch (err) {
  //     setSaveMessage("Failed to save book.");
  //   }
  //   setSaving(false);
  // };

  const deleteBook = async (itemid) => {
    if (!window.confirm("Are you sure you want to delete this book?")) return;
    try {
      const apiUrl = process.env.NEXT_PUBLIC_API_URL;
      await axios.post(`${apiUrl}/delprocess/deletebook`, { itemid }, {
          headers: {
            Authorization: `Bearer ${user?.token}`
          }
        });
      setResults(results.filter(book => book.itemid !== itemid));
      alert("Book deleted successfully.");
    } catch (err) {
      alert("Failed to delete book.");
    }
  };

  // Pagination logic
  const indexOfLastResult = currentPage * resultsPerPage;
  const indexOfFirstResult = indexOfLastResult - resultsPerPage;
  const currentResults = results.slice(indexOfFirstResult, indexOfLastResult);
  const totalPages = Math.ceil(results.length / resultsPerPage);

  const handlePageChange = (page) => {
    if (page >= 1 && page <= totalPages) setCurrentPage(page);
  };

  if (loading) {
    return <div>Loading...</div>;
  }

  const quickCards = [
    {
      title: 'Total Books Uploaded ',
      result: results.length,
      icon: bookIcon
    },
    {
      title: 'Matches Found',
      result: matchCount,
      icon: matchingIcon
    },
    {
      title: 'Rescan pending',
      result: pendingrescan,
      icon: pendingIcon
    },
  ];

  return (
    <Layout>
      <div className="max-w-5xl mx-auto my-10">
        <div className="flex flex-col xs:flex-row xs:items-center border bg-white border-[#e8e8e8] rounded px-5 py-4.5 gap-4 shadow-[0_0_8px_-4px_rgba(0,0,0,0.1)]">
          <h3 className="flex flex-col md:flex-row font-semibold text-[#373737] text-2xl">
            <span className="text-sm md:text-2xl">Welcome Back, </span>
            {user ? user.name : "Guest"}
          </h3>
          <a href="/upload" className="mr-auto xs:mr-0 xs:ml-auto h-10 sm:h-12 flex items-center justify-center text-sm sm:text-base gap-2 rounded-sm px-5 py-2.5 bg-primary text-white hover:bg-primaryDark cursor-pointer">
            <Image src={fileIcon} height={20} width={20} alt="view" className="p-1 cursor-pointer"/>
            Upload New Book
          </a>
        </div>
        <ul className="flex flex-wrap -mx-2.5 mt-5 mb-10">
          {quickCards.map((card, c) => (
            <li key={c} className="w-full xs:w-1/2 md:w-1/3 p-2.5">
              <StatusCard data={card}/>
            </li>
          ))}
        </ul>
        <h3 className="mb-5 font-semibold text-[#373737] text-2xl">Recent Books Uploaded</h3>
        <div className="table_wpr">
          <div className="relative overflow-x-auto">
            <table className="glob_table">
              <thead>
                <tr>
                  <th>Book</th>
                  <th>Upload Date</th>
                  <th>Status</th>
                  <th className="text-center">Scan Result</th>
                  <th className="text-center">Number of Rescan</th>
                  <th className="text-center">Action</th>
                </tr>
              </thead>
              <tbody>
                {currentResults.length === 0 ? (
                  <tr>
                    <td colSpan={6} className="text-center">No data found.</td>
                  </tr>
                ) : (
                  currentResults.map((result, r) => (
                    <tr key={r}>
                      <td className="max-w-32">{result.name}</td>
                      <td className="max-w-32">{result.date}</td>
                      <td>{result.status}</td>
                      <td className="text-center">
                        <Link
                          href={`/search?bookid=${result.itemid}`}
                          className="text-primary text-xs font-600"
                        >
                          Scan Result
                        </Link>
                      </td>
                      <td className="text-center">{result.rescan ?? 0}</td>
                      <td className="w-28">
                        <ul className="flex items-center justify-center space-x-1">
                          <li onClick={() => setBookDetails(result)}>
                            <Image src={EyeIcon} height={24} width={24} alt="view" className="p-1 cursor-pointer"/>
                          </li>
                          <li onClick={() => deleteBook(result.itemid)}>
                            <Image src={trashIcon} height={20} width={20} alt="delete" className="p-1 cursor-pointer"/>
                          </li>
                        </ul>
                      </td>
                    </tr>
                  ))
                )}
              </tbody>
            </table>
          </div>
        </div>
        {/* Pagination Controls */}
        <div className="flex justify-end mt-8">
          <ul className="flex items-center space-x-2">
            <li
              className={`px-3 h-8 border border-[#c9c9c9] flex items-center justify-center bg-white text-black text-sm font-medium rounded cursor-pointer ${currentPage === 1 ? 'opacity-50 cursor-not-allowed' : ''}`}
              onClick={() => handlePageChange(currentPage - 1)}
            >
              Prev
            </li>
            {[...Array(totalPages)].map((_, idx) => (
              <li
                key={idx}
                className={`w-8 h-8 border border-[#c9c9c9] flex items-center justify-center ${currentPage === idx + 1 ? 'bg-primary text-white' : 'bg-white text-black'} text-sm font-medium rounded cursor-pointer`}
                onClick={() => handlePageChange(idx + 1)}
              >
                {idx + 1}
              </li>
            ))}
            <li
              className={`px-3 h-8 border border-[#c9c9c9] flex items-center justify-center bg-white text-black text-sm font-medium rounded cursor-pointer ${currentPage === totalPages ? 'opacity-50 cursor-not-allowed' : ''}`}
              onClick={() => handlePageChange(currentPage + 1)}
            >
              Next
            </li>
          </ul>
        </div>
      </div>
      {isOpen && (
        <Modal>
          <div className="max-w-xl w-full bg-white rounded py-7 px-10 shadow-[0_0_40px_rgba(0,0,0,0.25)] relative" ref={modalRef}>
            {/* Close Button */}
            <button
              type="button"
              onClick={() => setIsOpen(false)}
              className="absolute top-3 right-3 text-gray-400 hover:text-gray-700 text-2xl font-bold focus:outline-none"
              aria-label="Close"
            >
              &times;
            </button>
            <label className="mb-2 block text-sm font-medium text-gray-700">
              Book Name
            </label>
            <div className="relative leading-0 mb-5">
              <input
                type="text"
                className="block w-full p-2.5 text-sm text-gray-900 bg-gray-50 rounded border border-gray-300 focus:ring-blue-500 focus:border-blue-500"
                placeholder="Book Name"
                value={bookName}
                onChange={(e) => setBookName(e.target.value)}
                readOnly
              />
            </div>
            <label className="mb-2 block text-sm font-medium text-gray-700">
              Author Name
            </label>
            <div className="relative leading-0 mb-5">
              <input
                type="text"
                className="block w-full p-2.5 text-sm text-gray-900 bg-gray-50 rounded border border-gray-300 focus:ring-blue-500 focus:border-blue-500"
                placeholder="Author Name"
                value={authorName}
                onChange={(e) => setAuthorName(e.target.value)}
                readOnly
              />
            </div>
            <label className="mb-2 block text-sm font-medium text-gray-700">
              Publisher Name
            </label>
            <div className="relative leading-0 mb-5">
              <input
                type="text"
                className="block w-full p-2.5 text-sm text-gray-900 bg-gray-50 rounded border border-gray-300 focus:ring-blue-500 focus:border-blue-500"
                placeholder="Publisher Name"
                value={publisherName}
                onChange={(e) => setPublisherName(e.target.value)}
                readOnly
              />
            </div>
            <label className="mb-2 block text-sm font-medium text-gray-700">
              Scan Keywords
            </label>
            <div className="relative leading-0 mb-5">
              <textarea
                className="block w-full p-2.5 text-sm text-gray-900 bg-gray-50 rounded border border-gray-300 focus:ring-blue-500 focus:border-blue-500"
                placeholder="Search Keywords"
                value={keyword}
                onChange={(e) => setKeyword(e.target.value)}
                readOnly
              ></textarea>
            </div>
            {saveMessage && (
              <div className={`mb-4 text-center text-sm ${saveMessage.includes("saved") ? "text-green-600" : "text-red-600"}`}>
                {saveMessage}
              </div>
            )}
            <div className="flex justify-end">
              {/* Save button here if needed */}
            </div>
          </div>
        </Modal>
      )}
    </Layout>
  );
}