import ReviewCarousel from "@/components/ReviewCarousel";
import SignInForm from "@/components/SignInForm";
import Image from "next/image";
import {logoWhite, loginCover} from "@/assets/images"

export default function SignIn() {
  return (
    <div className="relative bg-white z-1">
        <div className="relative md:h-screen flex flex-wrap w-full justify-center sm:p-0">
            <div className="flex flex-col w-full md:w-1/2 relative">
                <div className="absolute top-0 left-0 -z-[1] w-full md:h-screen">
                    <Image width={1200} height={1500} src={loginCover} alt="cover" className="h-48 md:h-screen object-cover"/>
                </div>
                <span className="absolute top-0 left-0 w-full h-48 md:h-screen z-[1] bg-linear-to-b from-[#01B97F] to-[#005339] opacity-70"></span>
                <div className="flex flex-col h-48 md:h-screen overflow-y-auto scroll_bar py-6 md:py-10">
                    <div className="flex flex-col items-start grow max-w-md xl:max-w-[600px] w-full mx-auto relative z-[2] px-5">
                        <Image width={240} height={50} src={logoWhite} alt="Logo" className="max-w-48 md:max-w-60"/>
                        <h1 className="text-xl md:text-3xl lg:text-4xl xl:text-[54px] lg:leading-11 xl:leading-15 text-white font-bold mb-2 md:mb-6 mt-[5dvh]">Welcome to the Authorguard</h1>
                        <h4 className="text-xs md:text-sm lg:text-base xl:text-lg xl:leading-7 text-white font-medium capitalize md:mb-8">Protect your stories, publish with confidence, and build your author brand — all in one place.</h4>
                        <div className="hidden md:block w-full mt-auto">
                            <ReviewCarousel />
                        </div>
                    </div>
                </div>
            </div>
            <SignInForm />
        </div>
    </div>
  );
}
