"use client";
import { useState } from "react";
import Layout from "@/components/Layout/LayoutAdmin";
import Image from "next/image";
import { AiOutlineEye, AiOutlineEyeInvisible } from 'react-icons/ai';
import {search, EyeIcon,  trashIcon, edit} from '@/assets/images'
export default function UserManagement() {
   const [showModal, setShowModal] = useState(false);
  const [showOld, setShowOld] = useState(false);
  const [showNew, setShowNew] = useState(false);
  const [showConfirm, setShowConfirm] = useState(false);

  return (
    <Layout>
        <div className="max-w-full flex items-center justify-center mx-auto my-10">
            
         
             <div className="bg-white p-6 rounded-md shadow-md w-full max-w-lg">
        <h2 className="text-xl font-semibold mb-4">← Edit Action</h2>

        <div className="mb-4">
          <label className="block text-sm font-medium mb-1">User Name</label>
          <input
            type="text"
            placeholder="Lorem Ipsum"
            className="w-full border rounded-md px-3 py-2 border-[#C4C4C4] outline-none focus:ring-2 focus:ring-green-500"
          />
        </div>

        <div className="mb-4">
          <label className="block text-sm font-medium mb-1">Plan Expiry Date</label>
          <input
            type="date"
            defaultValue="2026-01-15"
            className="w-full border rounded-md px-3 py-2 outline-none border-[#C4C4C4] focus:ring-2 focus:ring-green-500"
          />
        </div>

        <div className="flex justify-between mt-6">
          <button
            onClick={() => setShowModal(true)}
            className="border px-4 py-2 border-[#C4C4C4] cursor-pointer rounded-md hover:bg-gray-100 transition"
          >
            Change Password
          </button>
          <button className="bg-[#04B47D] text-white px-10 py-2 rounded-md hover:bg-green-700 transition">
            Save
          </button>
        </div>
            </div>

                
               {showModal && (
        <div className="fixed inset-0 bg-[#0000002f] bg-opacity-50 flex justify-center items-center z-50">
          <div className="bg-white p-6 rounded-md shadow-lg w-full max-w-lg relative">
            <button
              className="absolute top-2 right-2 text-gray-600 hover:text-black text-xl"
              onClick={() => setShowModal(false)}
            >
              &times;
            </button>

            <h2 className="text-lg font-semibold mb-4">Change Password</h2>

            {/* Old Password */}
            <div className="mb-4 relative">
              <label className="block text-sm font-medium mb-1">Old Password</label>
              <input
                type={showOld ? "text" : "password"}
                className="w-full border rounded-md px-3 py-2 pr-10 outline-none"
              />
              <div
                className="absolute right-3 top-[35px] text-gray-500 cursor-pointer"
                onClick={() => setShowOld(!showOld)}
              >
                {showOld ? <AiOutlineEyeInvisible /> : <AiOutlineEye />}
              </div>
            </div>

            {/* New Password */}
            <div className="mb-4 relative">
              <label className="block text-sm font-medium mb-1">New Password</label>
              <input
                type={showNew ? "text" : "password"}
                className="w-full border rounded-md px-3 py-2 pr-10 outline-none"
              />
              <div
                className="absolute right-3 top-[35px] text-gray-500 cursor-pointer"
                onClick={() => setShowNew(!showNew)}
              >
                {showNew ? <AiOutlineEyeInvisible /> : <AiOutlineEye />}
              </div>
            </div>

            {/* Confirm Password */}
            <div className="mb-4 relative">
              <label className="block text-sm font-medium mb-1">Confirm Password</label>
              <input
                type={showConfirm ? "text" : "password"}
                className="w-full border rounded-md px-3 py-2 pr-10 outline-none"
              />
              <div
                className="absolute right-3 top-[35px] text-gray-500 cursor-pointer"
                onClick={() => setShowConfirm(!showConfirm)}
              >
                {showConfirm ? <AiOutlineEyeInvisible /> : <AiOutlineEye />}
              </div>
            </div>

            <div className="flex justify-end">
              <button
                onClick={() => setShowModal(false)}
                className="bg-[#04b47d] text-white px-6 py-2 rounded-md hover:bg-green-700 transition"
              >
                Save
              </button>
            </div>
          </div>
        </div>
      )}
    </div>
         
            
           




   
    </Layout>
  );
}