'use client'
import { useState, useEffect, useRef } from 'react';
import Layout from "@/components/Layout/LayoutAdmin";
import StatusCard from "@/components/StatusCard";
import Image from "next/image";
import Modal from "@/components/Modal";
import { search, closeicon, trashIcon, edit, activecoupons, reddemoptions, discountamount } from '@/assets/images';
import axios from "axios";
import { useAuth } from "@/context/AuthContext";
import { useRouter } from 'next/navigation';
import { formatOnlyDate } from '@/utils/dateFormat';


export default function CoumponManagement() {
  const { user, loading } = useAuth();
  const [isOpen, setIsOpen] = useState(false);
  const [searchTerm, setSearchTerm] = useState('');
  const [results, setResults] = useState([]);
  
  const modalRef = useRef(null);
  const [code, setCode] = useState('');
  const [discount, setDiscount] = useState('');
  const [discountType, setDiscountType] = useState('percentage');
  const [status, setStatus] = useState('active');
  const [validFrom, setValidFrom] = useState('');
  const [validTo, setValidTo] = useState('');
  const [description, setDescription] = useState('');
  const [couponID, setCouponID] = useState(null);
  const [currentPage, setCurrentPage] = useState(1);
  const itemsPerPage = 10;

  // console.log(`User: ${user ? user.email : 'No user logged in'}`);




  const onClose = () => {
    setIsOpen(false);
      setCode('');
      setDiscount('');
      setDiscountType('percentage');
      setStatus('active');
      setValidFrom('');
      setValidTo('');
      setDescription('');
      setCouponID(null);
  }

  const openModalfunc = (user) => {
    if (!user || !user.token) { 
      alert('User not authenticated');
      return;
    }
    setIsOpen(true);
  };

  const dateOnly = (date) => {
    // if (!date) return '';
    const dateOnly = date.split('T')[0];
    console.log("dateOnly",dateOnly); // Output: 2025-06-17
    return dateOnly;
  }

  const editModalfunc = (result) => {
    console.log('Editing coupon:', result);
    
    if (!user || !user.token) {
      alert('User not authenticated');
      return;
    }
    const dateOnlyValidFrom = dateOnly(result.validFromDate);
    const dateOnlyValidTo = dateOnly(result.validToDate);
    console.log("dateOnlyValidFrom", dateOnlyValidFrom); // Output: 2025-06-17
    console.log("dateOnlyValidTo", dateOnlyValidTo); // Output: 2025-06-17
    setCode(result.code);
    setDiscount(result.discount);
    setDiscountType(result.discount_type || 'percentage');
    setStatus(result.status || 'active');
    setValidFrom(dateOnly(dateOnlyValidFrom) || '');
    setValidTo(dateOnly(dateOnlyValidTo) || '');
    setDescription(result.description || '');
    setCouponID(result.couponID || null);
    setIsOpen(true);
  };

  const createCoupon = async () => {
    if (!user || !user.token) {
      alert('User not authenticated');
      return;
    }
    try {
      await axios.post(
        `${apiUrl}/coupons/create`,
        {
          code,
          discount,
          discount_type: discountType,
          status,
          valid_from: validFrom,
          valid_to: validTo,
          description,
        },
        {
          headers: {
            Authorization: `Bearer ${user.token}`,
            'Content-Type': 'application/json',
          },
        }
      );
      setIsOpen(false);
      fetchCoupons();
      setCode('');
      setDiscount('');
      setDiscountType('percentage');
      setStatus('active');
      setValidFrom('');
      setValidTo('');
      setDescription('');
      setCouponID(null);
    } catch (error) {
      alert('Failed to create coupon');
    }
  };

  const updateCoupon = async () => {
    if (!user || !user.token) { 
      alert('User not authenticated');
      return;
    }
    try {
      await axios.put(
        `${apiUrl}/coupons/update/${couponID}`,
        {
          code,
          discount,
          discount_type: discountType,
          status,
          valid_from: validFrom,
          valid_to: validTo,
          description,
        },
        {
          headers: {
            Authorization: `Bearer ${user.token}`,
            'Content-Type': 'application/json',
          },
        } 
      );
      setIsOpen(false);
      fetchCoupons();
      setCode('');
      setDiscount('');
      setDiscountType('percentage');
      setStatus('active');
      setValidFrom('');
      setValidTo('');
      setDescription('');
      setCouponID(null);
    } catch (error) {
      alert('Failed to update coupon');
    }
  };
  


  useEffect(() => {
    function handleClickOutside(event) {
      if (modalRef.current && !modalRef.current.contains(event.target)) {
        setIsOpen(false);
      }
    }

    if (isOpen) {
      document.addEventListener("mousedown", handleClickOutside);
      document.body.classList.add("overflow-hidden");
    } else {
      document.body.classList.remove("overflow-hidden");
    }

    return () => {
      document.removeEventListener("mousedown", handleClickOutside);
    };
  }, [isOpen, user]);

  const apiUrl = process.env.NEXT_PUBLIC_API_URL;
  const fetchCoupons = async () => {
    try {
      const response = await axios.get(`${apiUrl}/coupons/`, {
        headers: {
          Authorization: `Bearer ${user?.token}`
        }
      });
      setResults(response.data || []);
    } catch (err) {
      setResults([]);
    }
  };

  useEffect(() => {
    if (user) fetchCoupons();
  }, [user]);

  const quickCards = [
    {
      title: 'Active coupons ',
      result: results.length,
      icon: activecoupons
    },
    {
      title: 'Redemptions',
      result: 187,
      icon: reddemoptions
    },
    {
      title: 'Total Discount Amount',
      result: '$1,250',
      icon: discountamount
    },
  ];

 


 

  const [activeTab, setActiveTab] = useState('All Books');

  // Filtered results based on searchTerm
  const filteredResults = results.filter(result => {
    const search = searchTerm.toLowerCase();
    return (
      result.code?.toLowerCase().includes(search) ||
      result.description?.toLowerCase().includes(search) ||
      result.status?.toLowerCase().includes(search)
    );
  });

  // Pagination logic
  const totalPages = Math.ceil(filteredResults.length / itemsPerPage);
  const paginatedResults = filteredResults.slice(
    (currentPage - 1) * itemsPerPage,
    currentPage * itemsPerPage
  );

  // Reset to first page when search term changes
  useEffect(() => {
    setCurrentPage(1);
  }, [searchTerm]);

  return (
    <Layout>
      <div className="max-w-full mx-auto my-10">
        <ul className="flex flex-wrap -mx-2.5 mt-5 mb-10">
          {quickCards.map((card, c) => (
            <li
              key={c}
              className={`w-full xs:w-1/2 ${c === 3 ? 'md:w-1/2' : 'md:w-1/3'} p-2.5`}
            >
              <StatusCard data={card} />
            </li>
          ))}
        </ul>

        <div className="border-b border-gray-200 mb-8">
          <div className="inline-flex relative">
            <button className="text-emerald-500 font-normal px-4 py-2">
              All Coupons 
            </button>
            <span className="absolute bottom-0 left-0 h-1 w-full bg-emerald-500 rounded"></span>
          </div>
        </div>

        <div className="flex items-center w-full max-w-full space-x-2 mb-5">
          <div className="flex items-center flex-grow border border-gray-300 rounded-md px-3">
            <Image src={search} width={'auto'} alt="search" />
            <input
              type="text"
              placeholder="Search by code or Description or Status"
              className="w-full pl-2 text-sm placeholder-gray-400 focus:outline-none leading-[56px]"
              value={searchTerm}
              onChange={e => setSearchTerm(e.target.value)}
            />
          </div>
          {/* Remove the Search button if not needed */}
        </div>

        <div className="flex flex-col xs:flex-row xs:items-center py-4.5 gap-4 xs:justify-between">
          <h3 className="mb-5 font-semibold text-[#373737] text-2xl">Coupon Management</h3>
          <button onClick={() => openModalfunc(user)} className="flex items-center gap-2 border cursor-pointer border-gray-300 rounded-md px-4 py-2 text-gray-700 hover:bg-gray-100 transition">
            <svg width="12" height="13" viewBox="0 0 12 13" fill="none" xmlns="http://www.w3.org/2000/svg">
              <path d="M5.50001 7.00001H0.500007C0.358007 7.00001 0.23934 6.95201 0.144007 6.85601C0.0486736 6.76001 0.000673516 6.64101 6.84931e-06 6.49901C-0.000659817 6.35701 0.0473402 6.23834 0.144007 6.14301C0.240674 6.04767 0.35934 6.00001 0.500007 6.00001H5.50001V1.00001C5.50001 0.858007 5.54801 0.73934 5.64401 0.644007C5.74001 0.548674 5.85901 0.500674 6.00101 0.500007C6.14301 0.49934 6.26167 0.54734 6.35701 0.644007C6.45234 0.740674 6.50001 0.85934 6.50001 1.00001V6.00001H11.5C11.642 6.00001 11.7607 6.04801 11.856 6.14401C11.9513 6.24001 11.9993 6.35901 12 6.50101C12.0007 6.64301 11.9527 6.76167 11.856 6.85701C11.7593 6.95234 11.6407 7.00001 11.5 7.00001H6.50001V12C6.50001 12.142 6.45201 12.2607 6.35601 12.356C6.26001 12.4513 6.14101 12.4993 5.99901 12.5C5.85701 12.5007 5.73834 12.4527 5.64301 12.356C5.54767 12.2593 5.50001 12.1407 5.50001 12V7.00001Z" fill="#575757" />
            </svg>
            <span className="text-base font-medium">Create Coupons</span>
          </button>

          {isOpen && (
            <Modal>
              <div className="max-w-xl w-full bg-white relative rounded py-7 px-10 shadow-[0_0_40px_rgba(0,0,0,0.25)]" ref={modalRef}>
                <button onClick={onClose} className="cursor-pointer absolute top-4 right-4 text-gray-500 hover:text-black">
                  <Image src={closeicon} alt='close' />
                </button>
                <h2 className="text-xl font-semibold mb-4">{couponID == null? "Create":"Update"} coupon</h2>

                <div className="grid grid-cols-2 gap-4 mb-6">
                  <input
                    type="hidden"
                    value={couponID}
                    onChange={e => setCouponID(e.target.value)}/>
                  <div>
                    <label className="block mb-1 text-sm font-normal">Code</label>
                    <input
                      type="text"
                      placeholder="Name of your code"
                      className="w-full border border-gray-300 rounded-md px-3 py-2 text-sm"
                      value={code}
                      onChange={e => setCode(e.target.value)}
                      {...couponID !== null ? { readOnly: true } : {}}
                    />
                  </div>
                  <div>
                    <label className="block mb-1 text-sm font-normal">Discount</label>
                    <input
                      type="text"
                      placeholder="Percentage/Fixed Amount of discount"
                      className="w-full border border-gray-300 rounded-md px-3 py-2 text-sm"
                      value={discount}
                      onChange={e => setDiscount(e.target.value)}
                    />
                  </div>
                </div>

                <div className="grid grid-cols-2 gap-4 mb-6">
                  <div>
                    <label className="block mb-1 text-sm font-normal">Discount Type</label>
                    <select
                      className="w-full border border-gray-300 rounded-md px-3 py-2 text-sm"
                      value={discountType}
                      onChange={e => setDiscountType(e.target.value)}
                    >
                      <option value="Percentage" {...discountType==="Percentage"?"selected":""}>Percentage</option>
                      <option value="Fixed" {...discountType==="Fixed"?"selected":""}>Fixed Amount</option>
                    </select>
                  </div>
                  <div>
                    <label className="block mb-1 text-sm font-normal">Status</label>
                    <select
                      className="w-full border border-gray-300 rounded-md px-3 py-2 text-sm"
                      value={status}
                      onChange={e => setStatus(e.target.value)}
                    >
                      <option value="active">Active</option>
                      <option value="inactive">Inactive</option>
                    </select>
                  </div>
                </div>

                <div className="mb-6">
                  <label className="block mb-1 text-sm font-normal">Description</label>
                  <textarea
                    placeholder="Write your description"
                    rows={3}
                    className="w-full border border-gray-300 rounded-md px-3 py-2 text-sm"
                    value={description}
                    onChange={e => setDescription(e.target.value)}
                  ></textarea>
                </div>

                <div className="grid grid-cols-2 gap-4 mb-6">
                  <div>
                    <label className="block mb-1 text-sm font-normal">Valid From</label>
                    <input
                      type="date"
                      className="w-full border border-gray-300 rounded-md px-3 py-2 text-sm"
                      value={validFrom}
                      onChange={e => setValidFrom(e.target.value)}
                    />
                  </div>
                  <div>
                    <label className="block mb-1 text-sm font-normal">Valid To</label>
                    <input
                      type="date"
                      className="w-full border border-gray-300 rounded-md px-3 py-2 text-sm"
                      value={validTo}
                      onChange={e => setValidTo(e.target.value)}
                    />
                  </div>
                </div>

                <div className="flex justify-end">
                  {couponID !== null ? (
                    <button
                      className="bg-[#04B47D] hover:bg-green-700 text-white px-6 py-2 rounded-md font-medium mr-2"
                      onClick={updateCoupon}
                    >
                      Update
                    </button>
                  ) : (
                    <button
                      className="bg-[#04B47D] hover:bg-green-700 text-white px-6 py-2 rounded-md font-medium mr-2"
                      onClick={createCoupon}
                    >
                      Create
                    </button>
                  )}
                  {/* <button
                    className="bg-[#04B47D] hover:bg-green-700 text-white px-6 py-2 rounded-md font-medium"
                    onClick={()=>submitAction(...couponID)}
                    
                  >
                    Save
                  </button> */}
                </div>
              </div>
            </Modal>
          )}
        </div>
        <div className="table_wpr pb-5">
          <div className="relative overflow-x-auto">
            <table className="glob_table">
              <thead>
                <tr>
                  <th>Sl. No.</th>
                  <th>Code</th>
                  <th>Description</th>
                  <th>Discount</th>
                  <th>Valid form</th>
                  <th>Valid to</th>
                  <th>Status</th>
                  <th className='text-center'>Actions</th>
                </tr>
              </thead>
              <tbody>
                {paginatedResults.map((result, r) => (
                  <tr key={r}>
                    <td className="max-w-32">{(currentPage - 1) * itemsPerPage + r + 1}</td>
                    <td className="max-w-32">{result.code}</td>
                    <td className="max-w-32">{result.description}</td>
                    <td>{result.discountType === "Fixed"?"$":"" }{result.discount}{result.discountType === "Percentage"?"%":"" } </td>
                    <td>{formatOnlyDate(result.validFromDate)}</td>
                    <td>{formatOnlyDate(result.validToDate)}</td>
                    <td>
                      <span className="inline-flex items-center space-x-1">
                        <span
                          className={`w-2 h-2 rounded-full ${
                            result.status?.toLowerCase() === 'active'
                              ? 'bg-green-600'
                              : result.status?.toLowerCase() === 'inactive'
                              ? 'bg-orange-400'
                              : result.status?.toLowerCase() === 'suspended'
                              ? 'bg-pink-500'
                              : result.status?.toLowerCase() === 'banned'
                              ? 'bg-red-500'
                              : result.status?.toLowerCase() === 'pending verification'
                              ? 'bg-indigo-400'
                              : 'bg-gray-300'
                          }`}
                        ></span>
                        <span
                          className={`text-sm ${
                            result.status?.toLowerCase() === 'active'
                              ? 'text-green-600'
                              : result.status?.toLowerCase() === 'inactive'
                              ? 'text-orange-500'
                              : result.status?.toLowerCase() === 'suspended'
                              ? 'text-pink-500'
                              : result.status?.toLowerCase() === 'banned'
                              ? 'text-red-500'
                              : result.status?.toLowerCase() === 'pending verification'
                              ? 'text-indigo-500'
                              : 'text-gray-500'
                          }`}
                        >
                          {result.status}
                        </span>
                      </span>
                    </td>
                    <td>
                      <ul className="flex items-center justify-center space-x-1">
                        <li className="cursor-pointer" onClick={() => editModalfunc(result)}>
                          <Image src={edit} width="auto" alt="Edit" />
                        </li>
                        <li className="cursor-pointer" onClick={() => {
                          if (confirm('Are you sure you want to delete this coupon?')) {
                            axios.delete(`${apiUrl}/coupons/delete/${result.couponID}`, {
                              headers: {
                                Authorization: `Bearer ${user?.token}`
                              }
                            })
                            .then(() => {
                              fetchCoupons();
                            })
                            .catch(err => {
                              console.error('Failed to delete coupon:', err);
                              alert('Failed to delete coupon');
                            });
                          }
                        }
                        }>
                          <Image src={trashIcon} width="auto" alt="Trash" />
                        </li>
                      </ul>
                    </td>
                  </tr>
                ))}
                {paginatedResults.length === 0 && (
                  <tr>
                    <td colSpan={8} className="text-center py-4 text-gray-500">No coupons found.</td>
                  </tr>
                )}
              </tbody>
            </table>
          </div>
        </div>

        {/* Pagination controls */}
        <div className="flex justify-end mt-8">
          <ul className="flex items-center space-x-2">
            <li>
              <button
                className="w-8 h-8 border border-[#c9c9c9] flex items-center justify-center bg-white text-black text-sm font-medium rounded cursor-pointer"
                onClick={() => setCurrentPage(p => Math.max(1, p - 1))}
                disabled={currentPage === 1}
              >
                Prev
              </button>
            </li>
            {[...Array(totalPages)].map((_, idx) => (
              <li key={idx}>
                <button
                  className={`w-8 h-8 border border-[#c9c9c9] flex items-center justify-center ${currentPage === idx + 1 ? 'bg-primary text-white' : 'bg-white text-black'} text-sm font-medium rounded cursor-pointer`}
                  onClick={() => setCurrentPage(idx + 1)}
                >
                  {idx + 1}
                </button>
              </li>
            ))}
            <li>
              <button
                className="w-8 h-8 border border-[#c9c9c9] flex items-center justify-center bg-white text-black text-sm font-medium rounded cursor-pointer"
                onClick={() => setCurrentPage(p => Math.min(totalPages, p + 1))}
                disabled={currentPage === totalPages}
              >
                Next
              </button>
            </li>
          </ul>
        </div>
      </div>
    </Layout>
  );
}