"use client";
import { tickIcon, tickWhiteIcon } from "@/assets/images";
import Layout from "@/components/Layout/Layout";
import Image from "next/image";
import { useAuth } from "@/context/AuthContext";
import axios from "axios";
import { useEffect, useState } from "react";


export default function Billing() {
  const { user, loading } = useAuth();
  const [results, setResults] = useState([]);
  const [couponcode, setCouponcode] = useState(null);
  const [couponData, setCouponData] = useState(null);
  const [planPrice, setPlanPrice] = useState([]); // Start as empty array

  const apiUrl = process.env.NEXT_PUBLIC_API_URL;

  const fetchPlans = async () => {
    try {
      const response = await axios.get(`${apiUrl}/getdata/plans`, {
          headers: {
            Authorization: `Bearer ${user?.token}`
          }
        });
      setResults(response.data || []);
      // Set planPrice as an array of prices from the plans
      setPlanPrice((response.data || []).map(plan => parseFloat(plan.price) || 0));
      
    } catch (err) {
      setResults([]);
      setPlanPrice([]);
    }
  };
  useEffect(() => {
    if (user?.token) {  
      fetchPlans();
    }
  }, [user]);

  const applyCoupon = async () => {
    if (!couponcode) {
      alert("Please enter a coupon code");
      return;
    }
    try {
      const response = await axios.get(
        `${apiUrl}/coupons/apply/${couponcode}`,
        {
          headers: {
            Authorization: `Bearer ${user?.token}`
          }
        }
      );
      setCouponData(response.data);

      console.log("Coupon data received:", response.data);
      // Apply discount to all plans
      if (response.data.coupon.discount) {
        console.log("Applying discount:", response.data.coupon.discount, response.data.coupon.discountType);
        setPlanPrice(planPrice =>
          planPrice.map((price) => {
            console.log("Applying discount to price:", price);
            price = parseFloat(price); // Ensure price is a number
            if (isNaN(price)) {
              console.error("Invalid price encountered:", price);
              return 0; // Fallback to 0 if price is invalid
            }
            if (response.data.coupon.discountType === "Percentage") {
              const discountAmount = (price * response.data.coupon.discount) / 100;
              console.log("Discount amount:", discountAmount);
              return Math.max(0, price - discountAmount);
            } else if (response.data.coupon.discountType === "Fixed") {
              console.log("Fixed discount amount:", response.data.coupon.discount);
              return Math.max(0, price - response.data.coupon.discount);
            }
            return price;
          })
        );
      }
      alert("Coupon applied successfully!");
    } catch (error) {
      alert("Failed to apply coupon. Please try again.");
    }
  };

  const buyNow = async (planId, planName, planPrice, couponId) => {
    // alert("couponcode: " + couponcode);
    if (!user?.token) {
      alert("Please login to continue");
      return;
    }
    try {
      const response = await axios.post(
        `${apiUrl}/checkout/create/`,
        {
          planId,
          planName,
          planPrice,
          couponcode
        },
        {
          headers: {
            Authorization: `Bearer ${user?.token}`
          }
        }
      );
      console.log("Checkout response:", response.data);
      if (response.data.error) {
        alert(response.data.error);
        return;
      }
      alert("Checkout initiated successfully!");
      window.location.href = response.data.url; // Redirect to the payment URL
    } catch (error) {
      console.error("Error during checkout:", error);
      alert("Failed to initiate checkout. Please try again.");
    }
  }




  return (

    <Layout>
      <div className="max-w-xs sm:max-w-2xl lg:max-w-5xl mx-auto my-10">
        <h3 className="mb-5 sm:mb-8 font-bold text-[#201A22] text-3xl sm:text-[42px] sm:leading-12 text-center">Subscription Plans</h3>

<ul className="flex flex-wrap -mx-3.5 justify-center">
      {results.map((plan, index) => (
        
        <li
          key={plan._id}
          className={`w-full sm:w-1/2 lg:w-1/3 p-3.5 ${
            plan.name === "Yearly" ? "order-3 lg:order-none" : ""
          }`}
        >
          <div
            className={`flex flex-col items-center p-8 ${
              plan.name === "Yearly" ? "bg-primary text-white" : "bg-white"
            } border border-[#424242]/[.17] rounded-2xl shadow-[0_0_8px_-2px_rgba(0,0,0,0.1)]`}
          >
            <div
              className={`${
                plan.name === "Yearly" ? "bg-[#3CCFA1]" : "bg-primary"
              } text-[15px] font-500 leading-7 text-white px-3.5 rounded-sm`}
            >
              {plan.name}
            </div>
            <h3
              className={`my-2 font-bold ${
                plan.name === "Yearly" ? "text-white" : "text-black"
              } text-[44px] leading-12 py-3`}
            >
              ${Number(planPrice[index] ?? plan.price).toFixed(2)}
            </h3>
            <div
              
              dangerouslySetInnerHTML={{ __html: plan.desc }}
            ></div>
             
            <button
              type="button"
              className={`max-w-52 w-full h-12 flex items-center justify-center text-base rounded ${
                plan.name === "Yearly"
                  ? "bg-white text-primary border border-white hover:bg-primaryDark"
                  : "text-primary border border-primary hover:bg-primaryDark"
              } cursor-pointer`}
              onClick={() => buyNow(plan._id, plan.name, planPrice[index] ?? plan.price, couponData?.coupon?._id)}
            >
              Buy Now
            </button>
          </div>
        </li>
      ))}
    </ul>
  



    

        <div className="max-w-lg mx-auto mt-16">
          <h4 className="text-[17px] leaidng-6 font-semibold text-black">Have a Coupon Code?</h4>
          <div className="flex space-x-1 sm:space-x-5 mt-2.5">
            <div className="relative grow">
              <input placeholder="" type="text" className="h-12 sm:h-[60px] w-full rounded border appearance-none px-4 py-2.5 text-sm shadow-theme-xs placeholder:text-gray-400 focus:outline-hidden   bg-transparent text-gray-800 border-[#c4c4c4] focus:border-brand-300 focus:ring-brand-500/20" onChange={(e)=>setCouponcode((e.target.value))} />
            </div>
            <button type="button" className="max-w-20 sm:max-w-40 w-full h-12 sm:h-[60px] flex items-center justify-center text-sm sm:text-base rounded bg-primary text-white hover:bg-primaryDark cursor-pointer" onClick={applyCoupon}>
              Apply
            </button>
          </div>
        </div>
      </div>
    </Layout>
  );
}