import type { Plugin } from 'unified';
import type { Root } from 'hast';
export type RehypeAttrsOptions = {
    /**
     * ## `data`
     *
     * ```markdown
     * text
     * <!--rehype:title=Rehype Attrs&abc=2-->
     * ```
     * 👇👇👇👇👇
     * ```html
     * <p data-config="data-config='[object Object]'">text</p>
     * ```
     *
     * ## `string`
     *
     * ```markdown
     * text
     * <!--rehype:title=Rehype Attrs-->
     * ```
     *
     * 👇👇👇👇👇
     *
     * ```html
     * <p data-config="{&#x22;title&#x22;:&#x22;Rehype Attrs&#x22;,&#x22;rehyp&#x22;:true}">text</p>
     * ```
     *
     * ## attr
     *
     * ```markdown
     * text
     * <!--rehype:title=Rehype Attrs-->
     * ```
     * 👇👇👇👇👇
     * ```html
     * <p title="Rehype Attrs">text</p>
     * ```
     * @default `data`
     */
    properties?: 'data' | 'string' | 'attr';
    /**
     * Code block passing parameters
     */
    codeBlockParames?: boolean;
};
declare const rehypeAttrs: Plugin<[RehypeAttrsOptions?], Root>;
export default rehypeAttrs;
