var express = require('express');
var router = express.Router();
const axios = require('axios');
const multer = require('multer');
const pdfParse = require('pdf-parse');
const mammoth = require('mammoth');
const FormData = require('form-data');
const { MongoClient } = require('mongodb');
var dburl = "mongodb://localhost:27017/authorguard";

router.post('/', async function (req, res, next) {
  // console.log('Received form data:', req);
  const formData = req.body;
  console.log('Received form data:', formData);
  console.log('Received file data:', req.file);
  // res.send('Form data received');

  if (!req.file) {
    return res.status(400).send('No file uploaded.');
  }
  const fileBuffer = req.file.buffer;
  const fileName = req.file.originalname.toLowerCase();
  try {
    // Check if the file is a PDF let extractedText = '';
    let extractedText = "";
    if (fileName.endsWith('.pdf')) {
      const data = await pdfParse(fileBuffer);
      extractedText = data.text;

    } else if (fileName.endsWith('.docx')) {
      const result = await mammoth.extractRawText({ buffer: fileBuffer });
      extractedText = result.value;
    } else if (fileName.endsWith('.doc')) {
      return res.status(400).send('.doc files not supported, convert to .docx.');
    } else if (fileName.endsWith('.epub')) {
        const form = new FormData();
        form.append('file', fileBuffer, {
            filename: req.file.originalname,  // Change file name here
            contentType: 'application/epub+zip' // Or 'application/pdf' / 'application/octet-stream'
        });

        // Post to backend
        const response = await axios.post('http://localhost:5000/extract-epub', form, {
            headers: form.getHeaders()
        });

        console.log('Response:', response.data);
        extractedText = response.data;
    } else {
      return res.status(400).send('Unsupported file type.');
    }
    console.log('Extracted Text:', extractedText);
    res.json({ text: extractedText });
  } catch (err) {
    console.error('Error parsing Document:', err);
    res.status(500).send('Failed to parse Document.');
  }
});

module.exports = router;
