var express = require('express');
var router = express.Router();
const axios = require('axios');
const { MongoClient, ObjectId } = require('mongodb');
var dburl = process.env.MONGODB_URL;
var serpapi_key = process.env.SERPAPI_KEY;
var serpapi_engine = process.env.SERPAPI_ENGINE;


/* GET home page. */
router.get('/', function (req, res, next) {
  // res.render('index', { title: req.query.key});
  let config = {
    method: 'get',
    maxBodyLength: Infinity,
    url: `https://serpapi.com/search.json?engine=${serpapi_engine}&search_query=' + req.query.key + '&api_key=${serpapi_key}`,
    headers: {}
  };

  axios.request(config)
    .then((response) => {
      // console.log(JSON.stringify(response.data));
      res.send(JSON.stringify(response.data, null, 2));
    })
    .catch((error) => {
      console.log(error);
    });
});

router.get('/auto', async function (req, res, next) {
  const client = new MongoClient(dburl);
  try {
    await client.connect();
    const db = client.db(); // defaults to 'authorguard' from the URL
    const processQueueCollection = db.collection('process_queue');
    const searchResultCollection = db.collection('search_result');
    const data = await processQueueCollection.find({ status: "Queued"}).toArray();
    console.log('Data:', data);
    if (data.length === 0) {
      return res.json({ message: "No items in the queue." });
    }
    let resultsStored = 0;

    // Sequentially process each item, waiting for each request to finish
    for (const item of data) {
      let config = {
        method: 'get',
        maxBodyLength: Infinity,
        url: `https://serpapi.com/search.json?engine=${serpapi_engine}&search_query=' + item.searchKey + '&api_key=${serpapi_key}`,
        headers: {}
      };

      try {
        const response = await axios.request(config);

        // Store the response in search_result collection
        await searchResultCollection.insertOne({
          processQueueId: item._id,
          searchKey: item.searchKey,
          createdAt: new Date(),
          result: response.data
        });

        // Update status to "Completed" in process_queue
        await processQueueCollection.updateOne(
          { _id: item._id },
          { $set: { status: "Completed", completedAt: new Date() } }
        );

        resultsStored++;
      } catch (error) {
        console.log(error);
      }
    }

    res.json({ message: `Stored ${resultsStored} search results and updated status.` });
  }
  finally {
    await client.close();
  }
});

module.exports = router;
