var express = require('express');
var router = express.Router();
const { MongoClient, ObjectId } = require('mongodb');
var dburl = process.env.MONGODB_URL;

router.post('/deletebook', async function (req, res, next) {
  const client = new MongoClient(dburl);
  try {
    await client.connect();
    const db = client.db();
    const collection = db.collection("uploads");

    const { itemid } = req.body;
    if (!itemid) {
      return res.status(400).json({ error: "Missing itemid" });
    }

    // Try to delete by ObjectId, fallback to string
    let result = null;
    try {
      result = await collection.deleteOne({ _id: new ObjectId(itemid) });
    } catch {
      result = await collection.deleteOne({ itemid: itemid });
    }

    if (result && result.deletedCount === 1) {
      res.json({ message: "Book deleted successfully." });
    } else {
      res.status(404).json({ error: "Book not found." });
    }
  } catch (err) {
    res.status(500).json({ error: "Internal server error." });
  } finally {
    await client.close();
  }
});

module.exports = router;
