var express = require('express');
var router = express.Router();
const { MongoClient, ObjectId } = require('mongodb');
var dburl = process.env.MONGODB_URL;
// console.log('MONGODB_URL:', dburl);


/* GET home page. */
router.post('/', async function(req, res, next) {
   const client = new MongoClient(dburl);
      try {
        await client.connect();
        const db = client.db(); // defaults to 'authorguard' from the URL
        const collection = db.collection('uploads');
        const processQueueCollection = db.collection('process_queue');
        const authID = (req.query.authID);
        const query = {};
        query['authID'] = authID;
        query['status'] = 'Processing';
        const data = await collection.find(query).toArray();
        console.log('Data:', data);
        const processQueue = data.map((item, idx) => ({
          itemid: item._id,
          title: item.title,
          date: new Date(),
          status: 'Queued',
          searchType: 'Basic',
          searchKey: item.title + ' ' + item.author + ' ' + item.publisher + ' ' + item.keywords,
        }));

        // Insert processQueue array into process_queue collection
        if (processQueue.length > 0) {
          await processQueueCollection.insertMany(processQueue);
        }

        res.json(processQueue);
      } finally {
        await client.close();
      }
}
);

// Secondary process creation endpoint
router.get('/secondary', async function(req, res, next) {
   const client = new MongoClient(dburl);
   try {
     await client.connect();
     const db = client.db();
     const collection = db.collection('uploads');
     const processQueueCollection = db.collection('process_queue');
    //  const authID = req.query.authID;
     const query = { /*authID: authID,*/ status: 'Processing' };
     const data = await collection.find(query).toArray();
     console.log('Secondary Data:', data);

     const getRandom10Words = (text, mimetype) => {
       if (!text) return '';
        if (mimetype === 'application/pdf') {
          // Handle PDF-specific logic if needed
          text = text;
        } else if (mimetype === 'application/epub+zip') {
          // Handle EPUB-specific logic if needed
          text = text.extracted_text;
        } else if (mimetype === 'application/vnd.openxmlformats-officedocument.wordprocessingml.document') {
          // Handle DOCX-specific logic if needed
          text = text;
        }
       const words = text.split(/\s+/).filter(Boolean);
       if (words.length <= 10) return words.join(' ');
       const start = Math.floor(Math.random() * (words.length - 9));
       return words.slice(start, start + 10).join(' ');
     };

     // Example: Mark as "Secondary" search type and add a flag
     const processQueue = data.map((item, idx) => ({
       itemid: item._id,
       title: item.title,
       date: new Date(),
       status: 'Queued',
       searchType: 'Secondary',
       secondaryFlag: true,
       searchKey: getRandom10Words(item.extractedText, item.mimetype),
     }));

     if (processQueue.length > 0) {
       await processQueueCollection.insertMany(processQueue);
     }

     res.json(processQueue);
   } finally {
     await client.close();
   }
});


module.exports = router;
